; Compiler: Avrasm2
#include "m8Adef.inc"

;                 "1234567812345678
#define sourceP   "PowerAC_03-05T__"   ; of Project
#define sourceB   "Pac3-5T_________"   ; for Boards
#define HEX_year  0x25
#define HEX_month 0x09
#define HEX_day   0x22
; __DATE__ , __TIME__ are in bin file

;===============================;========================================
;===============================;========================================
;===============================;========================================

;====
.DSEG
;====

    .org 0x0060

timeZC:   .Byte 1

;---------------------

; for loop, to clear registers
.equ SRAMstr = 0x60             ; up to 0x00FF (160 SRAM bytes)
;#define SRAMall                 ; to clear all 1024 registers

;===============================;============================================

;====
.CSEG
;====

;==========================
; **** SYSTEM constants ***
;==========================

; PCB: A73, D:\KiCad\Projects\Office\7segDrv\7segDrv_65_V_I-CT

; X2/TOSC2, X1/TOSC1, SCK, MISO, MOSI/OC2, SS/OC1B, OC1A, ICP1
; SWstr=inP,ADJi=inP,SWscn=inP,Dgt4=inP,Dgt3=inP,Dgt2=inP,Dgt1=outH,Hz=inT
.equ DDRBini0 = 0b0_0_0_0001_0  ; i i i iiio i
.equ PRTBini0 = 0b1_1_1_1111_0  ; P P P PPPH T

; PB1= Dgt1, PB2= Dgt2, PB3= Dgt3, PB3= Dgt4
; IMPORTANT: for DDRB (not PORTB), PORTB fixed & DDRB changed
.equ DIGITSof = 0b000_0000_0    ; iii iiii i  all off
.equ DIGIT1on = 0b000_0001_0    ; iii PPPP P, Dgt1 only on
.equ DIGIT2on = 0b000_0010_0    ; iii PPHP P, Dgt2 only on
.equ DIGIT3on = 0b000_0100_0    ; iii PHPP P, Dgt3 only on
.equ DIGIT4on = 0b000_1000_0    ; iii HPPP P, Dgt3 only on

; *** inputs *** 4
#define Hz_In    PINB,0         ; pin monitoring
#define Scrn_In  PINB,5
#define Adjst_In PINB,6
#define Strt_In  PINB,7

; *** outputs *** 4
; PB1= Dgt3, PB2= Dgt2, PB3= Dgt4, PB3= Dgt1

; *** reserved *** 0
; none

;===============================;===

; N/A, RESET(inP), ADC5/SCL, ADC4/SDA, ADC3, ADC2, ADC1, ADC0
; N/A,RST=inP,OUT=outH,MODv=inP,ADCi=inT,ADvH=inT,ADvL=inT,NC1=inP
.equ DDRCini0  = 0b00_1_0_000_0 ; xi o i iii i
.equ PRTCini0  = 0b01_1_1_000_1 ; xP H P TTT P

; *** inputs *** 4
#define ADJv_In PINC,4          ; adjust 220V, open for 220V, short for 380V
#define Pmod_In PINC,4          ; open = 3300W, short = 6600W
; PC1= ADC of Vlo
; PC2= ADC of Vhi
; PC3= ADC of Iin

; *** outputs *** 1
#define TRIAC_Out PORTC,5       ; 0=on , 1=off

; *** reserved *** 1+1+1[N/A]
; PC0, RST, PC7(N/A)

;===============================;===

; AIN1, AIN0, T1, XCK/T0, INT1, INT0, TXD, RXD
; SgB=inT,SgF=inT,SgA=inT,SgE=inT,SgD=inT,SgP=inT,SgC=inT,SgG=outL
; IMPORTANT: fix PORTD and change DDRD
.equ DDRDini0 = 0b00000001      ; iiiiiiio
.equ PRTDini0 = 0b00000000      ; TTTTTTTL

; *** inputs *** 0
; none

; *** outputs *** 8
.equ Seg_dot = 0x04
#define MIDboot DDRD,0          ; if 1, segmentG is lite, mid    seg
; PD7=Sg_B, PD6=Sg_F, PD5=Sg_A, PD4=Sg_E, PD3=Sg_D, PD1=Sg_C, PD0=Sg_G

; *** reserved *** 0
; none

;==========================
; *** PROGRAM constants ***
;==========================

#define b_ADIF   0x06,4         ; ADC Interrupt Flag

; Enable, Start, Free Run Select, (2^6) 8000/(64)=125 KHz, 104us
.equ ADC_init = 1<<ADEN | 1<<ADSC | 1<<ADFR | 0x06  ; POLL b_ADIF
; ADEN , ADSC , ADFR , ADIF , ADIE , ADPS2 , ADPS1 , ADPS0
;  1      1      1      0      0      1       1       0

;=============================
; *** PROGRAM hi-registers ***
;=============================

.def zero     = r3    ; zero value

; r1 & r0 for MUL and others

.equ REGstr = 1
.equ REGend = 25      ; for loop to clear registers


;===============================;========================================

    .org 0x0000

; MCUCSR: * , * , * , * , WDRF , BORF , EXTRF , PORF
    RJMP RESET      ; Reset Handler

    RJMP EXT_INT0   ; IRQ0 Handler
    RJMP EXT_INT1   ; IRQ1 Handler
    RJMP TIM2_COMP  ; Timer2 Compare Handler
    RJMP TIM2_OVF   ; Timer2 Overflow Handler
    RJMP TIM1_CAPT  ; Timer1 Capture Handler
    RJMP TIM1_COMPA ; Timer1 CompareA Handler
    RJMP TIM1_COMPB ; Timer1 CompareB Handler
    RJMP TIM1_OVF   ; Timer1 Overflow Handler
    RJMP TIM0_OVF   ; Timer0 Overflow Handler
    RJMP SPI_STC    ; SPI Transfer Complete Handler
    RJMP USART_RXC  ; USART RX Complete Handler
    RJMP USART_UDRE ; UDR Empty Handler
    RJMP USART_TXC  ; USART TX Complete Handler
    RJMP ADC_RDY    ; ADC Conversion Complete Handler
    RJMP EE_RDY     ; EEPROM Ready Handler
    RJMP ANA_COMP   ; Analog Comparator Handler
    RJMP TWSI       ; Two-wire Serial Interface Handler
    RJMP SPM_RDY    ; Store Program Memory Ready Handler

;---------------------
; 16 bytes Name & City
;---------------------

SIGNAT0:
   .db "AUTOLIGHT-ALEPPO"

SIGNAT1:
   .db  0x00, HEX_year, HEX_month, HEX_day ; number of bytes should be even
SIGNAT2:
   .db  sourceP
   .db  sourceB

   .db  __DATE__
   .db  __TIME__

;=============================
; *RI* Interrupts Handlers ***
;=============================

; IRQ0: PD2, pin4 [MCUCR , GICR , GIFR]
EXT_INT0:
    RETI

; IRQ1: PD3, pin5 [MCUCR , GICR , GIFR]
EXT_INT1:
    RETI

; Timer2 Compare: [TCCR2 , ASSR , TCNT2 , OCR2 , TIMSK , TIFR]
TIM2_COMP:
    RETI

; Timer2 Overflow: [TCCR2 , ASSR , TCNT2 , OCR2 , TIMSK , TIFR]
TIM2_OVF:
    RETI

; Timer1 Capture: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_CAPT:
    PUSH  r16
    IN    r16, TCNT1L
    STS   timeZC, r16
    POP   r16 
    RETI
;TICIE1

; Timer1 CompareA: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_COMPA:
    RETI

; Timer1 CompareB: [TCCR1A/B,TCNT1H/L,OCR1AH/L,OCR1BH/L,ICR1H/L,TIMSK ,TIFR]
TIM1_COMPB:
    RETI

; Timer1 Overflow: [TCNT1H/L, TIMSK , TIFR]
TIM1_OVF:
    RETI

; Timer0 Overflow: [TCCR0 , TCNT0]
TIM0_OVF:
    RETI

; SPI Transfer Complete: [SPCR , SPSR , SPDR]
SPI_STC:            ;
    RETI

; USART: RX Complete: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_RXC:
    RETI

; USART: UDR Empty: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_UDRE:
    RETI

; USART: TX Complete: [UDR , UDR , UBRRL , UCSRA , UCSRB]
USART_TXC:
    RETI

; ADC Conversion Complete: [ADCH/L , ADMUX , ADCSRA]
ADC_RDY:            ;
    RETI

; EEPROM Ready: [EEARH/L, EEDR , EECR]
EE_RDY:
    RETI

; Analog Comparator: [SFIOR , ACSR]
ANA_COMP:
    RETI

; Two-wire Serial Interface: [TWAR , TWDR , TWBR , TWCR , TWSR]
TWSI:
    RETI

; Store Program Memory Ready: [SPMCR]
SPM_RDY:
    RETI

;===================
; *** MAIN entry ***
;===================

RESET:
; SPH\L [Stack Pointer] = RAMEND [top of SRAM, 0x045F]
    LDI   r16,  low(RAMEND)
    LDI   r17, high(RAMEND)
    OUT   SPL, r16
    OUT   SPH, r17

; DDRB=DDRBini0
    LDI   r16, DDRBini0
    OUT   DDRB, r16
; PORTB=PRTBini0
    LDI   r17, PRTBini0
    OUT   PORTB, r17

; DDRC=DDRCini0
    LDI   r16, DDRCini0
    OUT   DDRC, r16
; PORTC=PRTCini0
    LDI   r17, PRTCini0
    OUT   PORTC, r17

; DDRD=DDRDini0
    LDI   r16, DDRDini0
    OUT   DDRD, r16
; PORTD=PRTDini0
    LDI   r17, PRTDini0
    OUT   PORTD, r17

; Wait for stable Vcc (the fuse BODEN should be enabled)
    IN    r16, MCUCSR           ; MCU Control and Status Register
    SBRS  r16, BORF             ; Test Brown-out Reset Flag
    RJMP  RST_cnt               ; Continue if 0

    CLR   r16                   ; Brown-out Reset Flag is 1
    OUT   MCUCSR, r16           ; Clear all flags
    RJMP  RESET                 ;  and reboot

;===============================;====================================
; clear low and high registers
RST_cnt:
    CLR   r0
    LDI   XH, high(REGstr)
    LDI   XL,  low(REGstr)      ; start of variables in low registers
CLR_lp1:
    ST    X+, r0
    CPI   XL, REGend+1          ; end of variables in high registers
    BREQ  CLRend1

    RJMP  CLR_lp1

CLRend1:
; clear extended static RAM registers
    LDI   XH, high(SRAMstr)
    LDI   XL,  low(SRAMstr)     ; 0x60
CLR_lp2:
    ST    X+, r0

#ifndef SRAMall
    TST   XL
    BREQ  CLRend2               ; 0x60 =< XL =< 0xFF (160)

    RJMP  CLR_lp2
#else ; no SRAMall
    CPI   XH, high(RAMEND+1)    ; 0x04 , RAMEND+1 = 0x0460
    BRLO  CLR_lp2
    CPI   XL,  low(RAMEND+1)    ; 0x60
    BRLO  CLR_lp2
#endif ; SRAMall

CLRend2:

;===============================;==========
;============= init variables ==;==========
;===============================;==========

; ACIC=0 [ACSR], enable input capture at ICP1
    CBI   ACSR, ACIC

; TCCR1A=0 , normal TMR1 mode
    OUT   TCCR1A, zero

; b2:0=010, /8 ==> 1us
; b7, Input Capture Noise Canceler for ICP1 input
; b6, Input Capture Edge Select for ICP1 input, rising edge
    LDI   r16, 0b11000010       ; <tst1>
    OUT   TCCR1B, r16

; enable capture interrupt routine
    LDI   r16, 1<<TICIE1
    OUT   TIMSK, r16

BOOT_hz:
; if ICF1=0, wait
    IN    r17, TIFR
    SBRS  r17, ICF1
    RJMP  BOOT_hz

;    OUT   TIFR, r17

; ADCSRA=ADC_init [1<<ADEN | 1<<ADSC | 1<<ADFR | 0x06]
;       =[Enable,Start,Free Run,8000/64=125 KHz] 104us/832c slide time
    LDI   r16, ADC_init
    OUT   ADCSRA, r16

; clear ADC flag [for simulIDE RESET]
    SBI   b_ADIF

MAINini:
; loop till ADC ends
    SBIS  b_ADIF
    RJMP  MAINini

; clear ADC flag [ by setting it to 1 ]
    SBI   b_ADIF

    RJMP  RESET

;===============================;====================================

